# Code for implement the model of EEG-image joint training and image generation
## Environment setup
Create and activate conda environment named dreamdiffusion from the env.yaml
```bash
conda env create -f env.yaml
conda activate dreamdiffusion
```
## Prepare dataset 
1. Revise the `wm_raw_data_dir` and `sk_raw_data_dir` in `config.py` to the path of the CVPR2017-WM-full and CVPR2017-SK-full.
2. Download image used in CVPR2017 dataset from the [link](https://drive.google.com/file/d/1y7I9bG1zKYqBM94odcox_eQjnP9HGo9-/view), unzip it and put the `imageNet_images` folder in the current directory.
3. run the following command to prepare the EEG data, extract image features with Clip encoder and split the dataset into training, validation and testing set. All these data will be saved in the `data` folder.
    ```bash
    python utils.py
    ```
## Run joint training
Run the following command to train the model for joint training. The training and testing result will be saved in the `log` folder.
```bash
# for cosine similarity loss
# para: subject, 0-9
# para: dataset, WM or SK
python main_cs.py --subject 0 --dataset WM
```
and
```bash
# for contrastive loss
# para: subject, 0-9
# para: dataset, WM or SK
python main_clip.py --subject 0 --dataset WM
```

## Run image generation
1. To run the image generation, you need to train the model for joint training with cosine similarity loss first. The saved EEGencoder will be used to initialize the EEGencoder in the image generation model.
2. For Stable Diffusion, we just use standard SD1.5. You can download it from the [official page of Stability](https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main). Download the file "v1-5-pruned.ckpt" and put it in the folder `./pretrains/models/`.
3. Fine-tune the diffusion model with the following command. Before running the command, you need to revise the `eeg_encoder_dir` in `eeg_ldm.py` to the path of the saved EEGencoder. The trained results will be saved in the `./exps/results/duffusion_finetune` folder. This will take about 12 hours for each subject with batch_size 8, num_epoch 100, on an Nvidia A800 GPU. 
    ```bash
    # para: subject, 0-9
    # para: dataset, WM or SK
    python eeg_ldm.py --dataset SK --subject 0 --batch_size 8 --num_epoch 100
    ```
4. Generate images for test set EEG with the following command.
    ```bash
    # para: subject, 0-9
    # para: dataset, WM or SK
    # para: model_date, the date of the trained model
    python gen_eval_eeg.py --dataset SK --subject 0 --model_date dd-mm-yy-hh-mm-ss
    ```
5. Evaluate the correctness of the generated images using n-way classification with the following command.
   
    ```bash
    python eval_gen_image.py
    ```
   
## Acknowledgement
This code is built upon the publicly available code [Mind-vis](https://github.com/zjc062/mind-vis) and [DreamDiffusion](https://github.com/bbaaii/DreamDiffusion). Thanks these authors for making their excellent work and codes publicly available.